package logger

import (
	"encoding/json"
	"fmt"
	"time"
)

// DebugLog defines the struct used for logs for CME team
type DebugLog struct {
	ClientID       string   `json:"client_id"`
	GameID         string   `json:"game_id"`
	BroadcasterIDs []string `json:"broadcaster_ids"`
	Timestamp      string   `json:"timestamp"`
	RawMessage     string   `json:"raw_message"`
}

// NewDebugLog method is to generate a new DebugLog object
func NewDebugLog(clientID string, gameID string, broadcasterIDs []string, rawMessage string) *DebugLog {
	return &DebugLog{
		ClientID:       clientID,
		GameID:         gameID,
		BroadcasterIDs: broadcasterIDs,
		Timestamp:      getCurrentTimestampUTC(),
		RawMessage:     rawMessage,
	}
}

// FormatMessage method is to serialize the struct to JSON string
func (d *DebugLog) FormatMessage() (string, error) {
	jsonBody, err := json.Marshal(*d)
	if err != nil {
		return "", err
	}
	return fmt.Sprintf("%s\n", string(jsonBody)), err
}

// the format of the timestamp is like: 2019-10-04T20:54:31Z
func getCurrentTimestampUTC() string {
	t := time.Now().UTC()
	return t.Format(time.RFC3339)
}
