package logger

import (
	"fmt"

	"code.justin.tv/karlpatr/message-prototype/libs/logging"
)

var logFuncs = map[logging.Level]logFunc{
	logging.Trace:   Trace,
	logging.Debug:   Debug,
	logging.Info:    Info,
	logging.Warning: Warn,
	logging.Error:   Error,
}

func Log(level logging.Level, msg ...interface{}) {
	loggingFunc, exists := logFuncs[level]
	if exists {
		loggingFunc(msg)
	} else {
		fmt.Println("Error setting up logging function :", msg)
	}
}
