package models

// Storing details for the connection
type ConnectionMetaData struct {
	Active         bool     // indicates whether the connection is live or not
	ClientID       string   // if authed, set it to the value from token
	BroadcasterIDs []string // A list of broadcaster ids related to the connection
	GameID         string   // The game this connection referes to, game and client id has a mapping relationship
	Env            string   // Environment tag
	IsServerData   bool     // indicating if this is client side data or server side data
	ConnectionID   int64    // Time of connection (ms since epoch). Used in combination with message_id.
	MessageID      int64    // Message number, unique to connection_id. Auto-incrementing.
	SessionID      string   // Game Session ID
}
