package models

type FullEvent struct {
	ClientID      string      `json:"client_id"`
	Env           string      `json:"env"`
	BroadcasterID string      `json:"broadcaster_id"`
	GameID        string      `json:"game_id"`
	Data          interface{} `json:"data"`
	FirstKeyFrame string      `json:"first_key_frame"`
	IsServerData  bool        `json:"is_server_data"`
}

type DeltaEvent struct {
	BroadcasterID string        `json:"broadcaster_id"`
	GameID        string        `json:"game_id"`
	Data          []interface{} `json:"data"`
	SeqStart      string        `json:"seq_start"`
	FirstKeyFrame string        `json:"first_key_frame"`
}

type BroadcasterKinesisInfo struct {
	BroadcasterID string
	LastFullState string
	FirstKeyFrame string
}
