package models

var DefaultReconnectMsg = `{"reconnect": 0}`

type ConnectMsg struct {
	Body *ConnectMsgData `json:"connect"`
}

type ConnectMsgData struct {
	BroadcasterIDs []string               `json:"broadcaster_ids"`
	SessionID      string                 `json:"session_id"`
	GameID         string                 `json:"game_id"`
	Env            string                 `json:"env"`
	Token          string                 `json:"token"`
	Data           map[string]interface{} `json:"data"`
	Debug          bool                   `json:"debug"`
}

type ConnectedMsg struct {
	Connected bool `json:"connected"`
}

type MessageTypes struct {
	Delta   []interface{}   `json:"delta"`
	Connect *ConnectMsgData `json:"connect"`
	Flush   *string         `json:"flush"`
	Refresh *RefreshBody    `json:"refresh"`
}

type DeltaMsg struct {
	Data []interface{} `json:"delta"`
}

type FlushMsg struct {
	ID string `json:"flush"`
}

type FlushResp struct {
	ID string `json:"flushed"`
}

type RefreshMsg struct {
	Body *RefreshBody `json:"refresh"`
}

type RefreshBody struct {
	Data map[string]interface{} `json:"data"`
}

type Metadata struct {
	Tags   []interface{} `json:"tags"`
	Active *bool         `json:"-"`
}

type ReconnectMsg struct {
	Reconnect int `json:"reconnect"` // in ms
}
