package processor

import (
	"context"

	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
)

func (d *DataProcessor) authorizeConnection(token, gameID string, broadcasterIDs []string) *e2models.ErrorMsg {
	ctx := context.Background()

	// Check if the token is valid
	resp, err := d.authClient.ValidateClient(ctx, token)
	if err != nil {
		return &e2models.ConnectInvalidToken
	}

	// Check if the client id is whitelisted
	// and able to publish data for the current game
	if err = d.authClient.IfWhitelistedClient(ctx, resp, gameID); err != nil {
		return &e2models.ConnectClientNotWhitelisted
	}

	// Set the client id field if auth passed
	d.connectionMetaData.ClientID = resp.ClientID

	// If this is a user token
	if resp.UserID != "" {
		if len(broadcasterIDs) != 0 && !ifGearBoxClients(resp.ClientID) {
			return e2models.BuildErrMsgByField(e2models.ConnectBadInfo, e2models.BroadcasterIDErr)
		}
		d.connectionMetaData.BroadcasterIDs = []string{resp.UserID}
	} else if d.authClient.IfTrustedSource(ctx, broadcasterIDs, resp) {
		// When it is app token, it is required to have broadcaster ids
		if len(broadcasterIDs) == 0 {
			return e2models.BuildErrMsgByField(e2models.ConnectBadInfo, e2models.BroadcasterIDErr)
		}
		// If this is an app token and allowed to use mdaas
		d.connectionMetaData.IsServerData = true
	} else {
		// if this is app token but not whitelisted, return error
		return &e2models.NotWhitelistedAppToken
	}

	return nil
}
