package processor

import (
	"fmt"
	"sync"

	"code.justin.tv/devhub/mdaas-ingest/models"

	"code.justin.tv/devhub/mdaas-ingest/logger"
)

type Buffer struct {
	C    chan models.MessageInfo
	once sync.Once
}

func NewBuffer(c chan models.MessageInfo) *Buffer {
	return &Buffer{C: c}
}

func (mc *Buffer) SafeClose() {
	mc.once.Do(func() {
		close(mc.C)
	})
}

func (d *DataProcessor) CloseBuffer() {
	defer func() {
		if r := recover(); r != nil {
			logger.Error(fmt.Sprintln("Recovered in f", r))
		}
	}()
	logger.Trace("Close buffer upon connection close.")
	d.buffer.SafeClose()
}

func (d *DataProcessor) PutToBuffer(msg models.MessageInfo) {
	d.buffer.C <- msg
}

func (d *DataProcessor) SetToPauseState() {
	d.pauseOnErr = true
}

func (d *DataProcessor) GetBufferSize() int {
	return len(d.buffer.C)
}
