package processor

import (
	"context"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/devhub/mdaas-ingest/config"

	"code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
)

func (d *DataProcessor) fanoutToFullStateKinesis() *e2models.ErrorMsg {
	// For edge-only testings
	if !config.GetConfigs().FanoutKinesis {
		return nil
	}

	e := d.buildFullStateEvent()
	updatedInfo, err := d.publisher.Publish(context.Background(), e, d.cloneToBroadcasterInfo)
	if err != nil {
		log.Error(err)
		return &e2models.UnexpectedFailure
	}

	d.cloneToBroadcasterInfo = updatedInfo
	d.deltaPublishCount = 0

	return nil
}

func (d *DataProcessor) fanoutToDeltaKinesis(data []interface{}) *e2models.ErrorMsg {

	// Do not publish if the data is just an empty placeholder to keep live
	if len(data) == 0 {
		return nil
	}

	if d.deltaPublishCount == deltaPackInterval {
		return d.fanoutToFullStateKinesis()
	}

	// For edge-only testings
	if !config.GetConfigs().FanoutKinesis {
		return nil
	}

	e := d.buildDeltaEvent(data)

	// updated info not needed when fanning out deltas
	_, err := d.publisher.Publish(context.Background(), e, d.cloneToBroadcasterInfo)
	if err != nil {
		log.Error(err)
		return &e2models.UnexpectedFailure
	}

	d.deltaPublishCount++
	return nil
}

func (d *DataProcessor) buildDeltaEvent(data []interface{}) models.Event {
	delta := models.DeltaEvent{
		GameID: d.connectionMetaData.GameID,
		Data:   data,
	}
	return models.Event{Delta: &delta}
}

func (d *DataProcessor) buildFullStateEvent() models.Event {
	full := models.FullEvent{
		ClientID:     d.connectionMetaData.ClientID,
		Env:          d.connectionMetaData.Env,
		GameID:       d.connectionMetaData.GameID,
		Data:         d.data,
		IsServerData: d.connectionMetaData.IsServerData,
	}
	return models.Event{Full: &full}
}
