package processor

import (
	"fmt"

	"code.justin.tv/devhub/mdaas-ingest/config"
	"code.justin.tv/devhub/twitch-e2-ingest/models"
	log "github.com/sirupsen/logrus"
)

func (d *DataProcessor) buildSNSFullData(data interface{}, time int64) models.GameFullData {
	var clientType models.ClientType
	if d.connectionMetaData.IsServerData {
		clientType = models.AppToken
	} else {
		// default to user token
		clientType = models.UserToken
	}
	return models.GameFullData{
		Active:         d.connectionMetaData.Active,
		ClientID:       d.connectionMetaData.ClientID,
		Env:            d.connectionMetaData.Env,
		BroadcasterIDs: d.connectionMetaData.BroadcasterIDs,
		GameID:         d.connectionMetaData.GameID,
		Time:           time,
		ConnectionID:   d.connectionMetaData.ConnectionID,
		MessageID:      d.connectionMetaData.MessageID + 1, // message id starts from 1
		SessionID:      d.connectionMetaData.SessionID,
		Data:           data,
		ClientType:     clientType,
	}
}

func (d *DataProcessor) fanoutSNSFullData(time int64) *models.ErrorMsg {
	snsData := d.buildSNSFullData(d.data, time)
	if err := d.snsPublisher.PublishByARN(snsData, d.getARNByConnectionInfo()); err != nil {
		log.Error(err)
		return &models.UnexpectedFailure
	}
	d.connectionMetaData.MessageID = snsData.MessageID
	return nil
}

func (d *DataProcessor) canGetArnByConnectionInfo() bool {
	if d.connectionMetaData.GameID == "" || d.connectionMetaData.ClientID == "" || d.connectionMetaData.Env == "" {
		return false
	}

	return true
}

func (d *DataProcessor) getARNByConnectionInfo() string {
	return fmt.Sprintf("arn:aws:sns:us-west-2:%s:game-%s_client-%s_env-%s", config.GetAccountID(), d.connectionMetaData.GameID, d.connectionMetaData.ClientID, d.connectionMetaData.Env)
}
