package processor

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/devhub/mdaas-ingest/internal/metrics"
	models "code.justin.tv/devhub/mdaas-ingest/models"
)

func (d *DataProcessor) ProcessCloseSignal(messageInfo models.MessageInfo) error {

	if !d.canGetArnByConnectionInfo() {
		return nil
	}

	d.connectionMetaData.Active = false

	// Fan out metadata to SNS
	go d.fanoutFullToSNS(d.data, true)

	// Fan out full data to SNS
	errResp := d.fanoutSNSFullData(messageInfo.Time)
	if errResp != nil {
		return errResp
	}

	// Report close signal process time
	metrics.Reporter().Report("ProcessTimeCloseSignal", metrics.GetDurationByMS(messageInfo.Time), telemetry.UnitSeconds)
	return nil
}
