package processor

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/devhub/mdaas-ingest/internal/metrics"
	models "code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
)

func (d *DataProcessor) processFlushPack(flushPack models.FlushMsg, time int64) interface{} {
	if d.pauseOnErr && d.connectionMetaData.ClientID != "" {
		return &e2models.WaitingOnRefreshPack
	}

	// Check if the connection is authed first
	if d.connectionMetaData.ClientID == "" {
		return &e2models.ConnectionNotAuthed
	}

	// Report flush message process time
	metrics.Reporter().Report("ProcessTimeFlush", metrics.GetDurationByMS(time), telemetry.UnitSeconds)
	return &models.FlushResp{ID: flushPack.ID}
}
