package processor

import (
	"encoding/json"
	"time"

	models "code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"

	. "code.justin.tv/devhub/mdaas-ingest/test_utils"
)

func (suite *ProcessorTest) TestProcessValidFlushPack() {
	resp := suite.processor.ProcessDataPack(models.MessageInfo{Message: StandardFlushPack, Time: time.Now().UnixNano()})
	result, err := json.Marshal(resp)
	suite.Nil(err)
	suite.Equal(string(result), "{\"flushed\":\"flushID\"}")
	suite.publisher.AssertNotCalled(suite.T(), "SavePublishedStateDataInS3")
}

func (suite *ProcessorTest) TestProcessNotAuthedFlushMessage() {
	suite.processor.connectionMetaData.ClientID = ""

	resp := suite.processor.ProcessDataPack(models.MessageInfo{Message: StandardFlushPack, Time: time.Now().UnixNano()})
	suite.Equal(resp, &e2models.ConnectionNotAuthed)
	suite.publisher.AssertNotCalled(suite.T(), "SavePublishedStateDataInS3")
}

func (suite *ProcessorTest) TestProcessValidFlushPack_withDebugFlag() {
	suite.processor.debug = true

	testMessageInfo := GenerateMessageInfoFromRawMessage(StandardFlushPack, time.Now().UnixNano())
	expectedDebugLog, jsonErr := GenerateDebugLogJSON(suite.connectionData.ClientID, suite.connectionData.GameID, suite.connectionData.BroadcasterIDs, testMessageInfo.Message)
	suite.NoError(jsonErr)
	suite.publisher.On("SavePublishedStateDataInS3", expectedDebugLog).Return()
	resp := suite.processor.ProcessDataPack(testMessageInfo)

	time.Sleep(10 * time.Millisecond)

	result, err := json.Marshal(resp)
	suite.Nil(err)
	suite.Equal(string(result), "{\"flushed\":\"flushID\"}")
}
