package processor

import (
	"encoding/json"

	"code.justin.tv/devhub/mdaas-ingest/logger"

	models "code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
	log "github.com/sirupsen/logrus"
)

func (d *DataProcessor) ProcessDataPack(message models.MessageInfo) interface{} {
	data := &models.DeltaMsg{}
	rawMessage := message.Message
	err := json.Unmarshal([]byte(rawMessage), data)
	if err == nil && data.Data != nil {
		return d.processDeltaPack(*data, message)
	}

	var connectMsg = &models.ConnectMsg{}
	err = json.Unmarshal([]byte(message.Message), connectMsg)
	if err == nil && connectMsg.Body != nil {
		return d.processConnectPack(*connectMsg, message.Time)
	}

	var refreshData = &models.RefreshMsg{}
	err = json.Unmarshal([]byte(message.Message), refreshData)
	if err == nil && refreshData.Body != nil && refreshData.Body.Data != nil {
		return d.processRefreshPack((*refreshData.Body).Data, message)
	}

	flushData := &models.FlushMsg{
		ID: "",
	}
	err = json.Unmarshal([]byte(message.Message), flushData)
	if err == nil && flushData.ID != "" {
		go d.saveValidReplayDataInS3(rawMessage)
		return d.processFlushPack(*flushData, message.Time)
	}

	return &e2models.BadDataPack
}

// Jira: https://jira.twitch.com/browse/MDAAS-100
// Everytime a pack data is processed succfully, we save a copy into S3
// run this method in another go routine to reduce latency and make sure the error won't block the main routine
func (d *DataProcessor) saveValidReplayDataInS3(message string) {
	if !d.debug {
		return
	}
	debugLog := logger.NewDebugLog(d.connectionMetaData.ClientID, d.connectionMetaData.GameID, d.connectionMetaData.BroadcasterIDs, message)
	json, jsonErr := debugLog.FormatMessage()
	if jsonErr != nil {
		log.Errorf("Error when formating DebugLog: %v\n", jsonErr)
		return
	}
	d.publisher.SavePublishedStateDataInS3(json)
}

func maskTokenInConnectMessage(connectPackData models.ConnectMsgData) ([]byte, error) {
	// because inside ConnectPack it's using pointer, so here pass in ConnectMsgData
	// so that we can deep copy ConnectMsgData
	connectPackData.Token = "***"
	connectMsg := &models.ConnectMsg{
		Body: &connectPackData,
	}
	return json.Marshal(connectMsg)
}
