package processor

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/devhub/mdaas-ingest/internal/metrics"
	models "code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
)

func (d *DataProcessor) processRefreshPack(refreshPack map[string]interface{}, messageInfo models.MessageInfo) *e2models.ErrorMsg {
	// Check if the connection is authed first
	if d.connectionMetaData.ClientID == "" {
		return &e2models.ConnectionNotAuthed
	}

	d.pauseOnErr = false

	// Validate if metadata field is valid
	if validatedErr := validateMetadata(refreshPack); validatedErr != nil {
		return e2models.BuildErrMsgByField(e2models.RefreshMissingInfo, validatedErr.Field)
	}

	// refresh everything
	d.CleanData()

	d.data = refreshPack

	// Fan out metadata to SNS
	go d.fanoutFullToSNS(refreshPack, true)
	// save debug log to S3
	go d.saveValidReplayDataInS3(messageInfo.Message)

	// Fan out to kinesis
	errResp := d.fanoutToFullStateKinesis()
	if errResp != nil {
		return errResp
	}

	// Fan out full data to SNS
	errResp = d.fanoutSNSFullData(messageInfo.Time)
	if errResp != nil {
		return errResp
	}

	// Report refresh message process time
	metrics.Reporter().Report("ProcessTimeRefresh", metrics.GetDurationByMS(messageInfo.Time), telemetry.UnitSeconds)

	return nil
}
