package processor

import (
	"code.justin.tv/devhub/mdaas-ingest/internal/clients/kinesis"
	models "code.justin.tv/devhub/mdaas-ingest/models"
	"code.justin.tv/devhub/twitch-e2-ingest/authentication"
	"code.justin.tv/devhub/twitch-e2-ingest/sns"
)

const deltaPackInterval = 9

type (
	PackType string
)

//go:generate go run github.com/vektra/mockery/cmd/mockery -name Processor
type Processor interface {
	ProcessCloseSignal(msg models.MessageInfo) error
	ProcessDataPack(message models.MessageInfo) interface{}
	CleanData()
	CloseBuffer()
	PutToBuffer(msg models.MessageInfo)
	SetToPauseState()
	GetBufferSize() int
	GetConnectionClientID() string
	GetConnectionDetails() string
}

// processor for data pack - full state and delta state
type DataProcessor struct {
	connectionMetaData     models.ConnectionMetaData // connection info and metadata
	authClient             authentication.Auth
	data                   map[string]interface{} // the current hold full state data
	publisher              kinesis.Publisher
	snsPublisher           sns.Publisher
	buffer                 *Buffer
	pauseOnErr             bool
	deltaPublishCount      int
	cloneToBroadcasterInfo [][]models.BroadcasterKinesisInfo
	debug                  bool
}

func NewDataProcessor(authClient authentication.Auth, publisher kinesis.Publisher, snsPublisher sns.Publisher, buffer chan models.MessageInfo) *DataProcessor {
	return &DataProcessor{
		models.ConnectionMetaData{},
		authClient,
		make(map[string]interface{}),
		publisher,
		snsPublisher,
		NewBuffer(buffer),
		false,
		0,
		make([][]models.BroadcasterKinesisInfo, 1),
		false,
	}
}
