package processor

import (
	"encoding/json"
	"testing"
	"time"

	pmocks "code.justin.tv/devhub/mdaas-ingest/internal/clients/kinesis/mocks"
	. "code.justin.tv/devhub/mdaas-ingest/models"
	. "code.justin.tv/devhub/mdaas-ingest/test_utils"
	amocks "code.justin.tv/devhub/twitch-e2-ingest/authentication/mocks"
	smocks "code.justin.tv/devhub/twitch-e2-ingest/sns/mocks"
	"github.com/stretchr/testify/suite"
)

type ProcessorTest struct {
	suite.Suite
	processor          *DataProcessor
	auth               *amocks.Auth
	connectionData     ConnectionMetaData
	data               map[string]interface{}
	publisher          *pmocks.Publisher
	snsPublisher       *smocks.Publisher
	buffer             chan MessageInfo
	fullEvent          Event
	cloneToKinesisInfo [][]BroadcasterKinesisInfo
	initialMapping     [][]BroadcasterKinesisInfo
	debug              bool
}

func (suite *ProcessorTest) SetupTest() {
	suite.auth = &amocks.Auth{}
	suite.connectionData = ConnectionMetaData{
		ClientID:       TestClientID,
		BroadcasterIDs: []string{GetTestString(TestBroadcasterID, 1), GetTestString(TestBroadcasterID, 2)},
		GameID:         TestGameID,
		Env:            "dev",
		IsServerData:   true,
		ConnectionID:   time.Now().UnixNano(),
		MessageID:      3,
		SessionID:      TestSessionID,
	}
	var data ConnectMsg
	err := json.Unmarshal([]byte(StandardConnectionData), &data)
	suite.NoError(err)

	suite.data = data.Body.Data
	suite.publisher = &pmocks.Publisher{}
	suite.snsPublisher = &smocks.Publisher{}
	suite.buffer = make(chan MessageInfo, 10) // make a smaller size buffer in unit test
	suite.debug = data.Body.Debug

	full := &FullEvent{
		ClientID:     suite.connectionData.ClientID,
		Env:          suite.connectionData.Env,
		GameID:       suite.connectionData.GameID,
		Data:         suite.data,
		IsServerData: true,
	}

	suite.fullEvent = Event{Full: full}

	suite.cloneToKinesisInfo = GetCloneToBroadcasterMapping(NormalMessage)
	suite.initialMapping = GetCloneToBroadcasterMapping(FirstMessage)

	suite.processor = &DataProcessor{
		suite.connectionData,
		suite.auth,
		suite.data,
		suite.publisher,
		suite.snsPublisher,
		NewBuffer(suite.buffer),
		false,
		0,
		suite.cloneToKinesisInfo,
		suite.debug,
	}
}

func (suite *ProcessorTest) TearDownTest() {
	suite.publisher.AssertExpectations(suite.T())
	suite.snsPublisher.AssertExpectations(suite.T())
	suite.auth.AssertExpectations(suite.T())
}

func TestRunProcessorSuite(t *testing.T) {
	suite.Run(t, new(ProcessorTest))
}
