package processor

import (
	models "code.justin.tv/devhub/mdaas-ingest/models"
	e2models "code.justin.tv/devhub/twitch-e2-ingest/models"
)

const MetadataLabel = "_metadata"
const ActiveSwitch = "active"

func (d *DataProcessor) validateConnectPackRequiredInfo(connectPack models.ConnectMsg) *e2models.ErrorMsg {
	if connectPack.Body.Token == "" {
		return e2models.BuildErrMsgByField(e2models.ConnectMissingInfo, e2models.TokenErr)
	}

	if connectPack.Body.GameID == "" {
		return e2models.BuildErrMsgByField(e2models.ConnectMissingInfo, e2models.GameIDErr)
	}

	// TODO: remove this hacky logic only apply for gearbox when they are read to move to session_id
	if !ifGearBoxClients(d.connectionMetaData.ClientID) && connectPack.Body.SessionID == "" {
		return e2models.BuildErrMsgByField(e2models.ConnectMissingInfo, e2models.SessionIDErr)
	}

	// env tag should only be prod or dev, if we need more values, use enum and a function to extract this logic
	if connectPack.Body.Env != "prod" && connectPack.Body.Env != "dev" {
		return e2models.BuildErrMsgByField(e2models.ConnectBadInfo, e2models.EnvErr)
	}

	return validateMetadata(connectPack.Body.Data)
}

func validateMetadata(initialData map[string]interface{}) *e2models.ErrorMsg {
	// If there is metadata field
	if data, exists := initialData[MetadataLabel]; exists {
		// when matadata field is map
		if metadata, ok := data.(map[string]interface{}); ok {
			// TODO: disable active check until we find the right usage of it
			// It will not be sent as output to SNS, json marked as "-"
			// if metadata[ActiveSwitch] == nil {
			//	return BuildErrMsgByField(ConnectMissingInfo, ActiveErr)
			// }

			// if _, ok := metadata[ActiveSwitch].(bool); !ok {
			// 	return BuildErrMsgByField(ConnectBadInfo, ActiveErr)
			// }

			if tags, ok := metadata["tags"]; ok {
				if _, ok := tags.([]interface{}); ok {
					return nil
				} else {
					return e2models.BuildErrMsgByField(e2models.ConnectBadInfo, e2models.TagErr)
				}
			}
		} else {
			// metadata field is not even a map
			return e2models.BuildErrMsgByField(e2models.ConnectBadInfo, e2models.MetadataErr)
		}
	}

	return nil
}

var gearboxClients = []string{"6wuh7gjktttd9ufkpv8hbw6xuimmvp", "adnavtcottq1sx2kau3ewvhpmuaunu", "icq85cf6kjgmlg4vi9f61nnp6ulgk6", "kd21l55x534ldtbvpbrzjaugjsj7s1"}

func ifGearBoxClients(clientID string) bool {
	for _, id := range gearboxClients {
		if id == clientID {
			return true
		}
	}
	return false
}
