package ratelimiter

import (
	"testing"

	"github.com/stretchr/testify/suite"
)

type RatelimiterTest struct {
	suite.Suite
	ratelimiter RateLimiter
}

func (s *RatelimiterTest) SetupTest() {
	s.ratelimiter = NewRateLimiter()
}

func (s *RatelimiterTest) TestExceedRateLimiting() {
	for i := 1; i <= 60; i++ {
		s.False(s.ratelimiter.IfExceedLimit())
	}
	s.True(s.ratelimiter.IfExceedLimit())
}

func (s *RatelimiterTest) TearDownTest() {}

func TestRatelimiterSuite(t *testing.T) {
	suite.Run(t, new(RatelimiterTest))
}
