package server

import (
	"sync"
)

type Bindings struct {
	Bindings map[string]*Binding
	lock     sync.Mutex
}

func (b *Bindings) Lock() {
	b.lock.Lock()
}

func (b *Bindings) Unlock() {
	b.lock.Unlock()
}

func (b *Bindings) Add(key string, value *Binding) {
	b.Bindings[key] = value
}

func (b *Bindings) Remove(key string) {
	delete(b.Bindings, key)
}
