package server

import (
	"reflect"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"

	"code.justin.tv/devhub/mdaas-ingest/internal/metrics"
	"code.justin.tv/devhub/mdaas-ingest/models"
)

func (b *Binding) handleDataStream(msg <-chan models.MessageInfo) {
	for job := range msg {
		dimensions := map[string]string{
			"clientID": b.processor.GetConnectionClientID(),
		}
		metrics.Reporter().Report("NumOfMessagesToProcess", 1.0, telemetry.UnitCount, dimensions)

		// Always make sure the buffer got cleaned before close it
		if job.Message == closeMessage {
			if resp := b.processor.ProcessCloseSignal(job); reflect.ValueOf(resp).Kind() == reflect.Ptr && !reflect.ValueOf(resp).IsNil() {
				b.writeFeedback(resp)
			}

			b.processor.CloseBuffer()
		} else if resp := b.processor.ProcessDataPack(job); reflect.ValueOf(resp).Kind() == reflect.Ptr && !reflect.ValueOf(resp).IsNil() {
			// Upon all kinds of error, existing data should be nuked first
			// and wait for new full data like connect package to come in (including metadata tag)
			b.writeFeedback(resp)
		} else {
			// When message successfully processed
			metrics.Reporter().Report("NumOfSuccessMessages", 1.0, telemetry.UnitCount, dimensions)
		}
	}
	// Do nothing upon success, only need feedback mechanisms when erroring
}
