package server

import (
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/devhub/mdaas-ingest/internal/metrics"
)

func (b *Binding) reportMetrics() {
	for {
		time.Sleep(1000 * time.Millisecond)

		if b.closedSignal {
			break
		} else {
			// Report metrics
			metrics.Reporter().Report("LiveConnections", 1.0, telemetry.UnitCount)
			metrics.Reporter().Report("BufferSize", float64(b.processor.GetBufferSize()), telemetry.UnitCount)
		}
	}
}
