package server

import (
	"code.justin.tv/devhub/mdaas-ingest/models"
	e2SharedModels "code.justin.tv/devhub/twitch-e2-ingest/models"
)

func (suite *ServerTest) TestWriteFeedbackWithFlushResponse() {
	flushed := &models.Flushed{Flushed: "123"}
	suite.mockSessionClient.On("WriteBinaryAsText", []byte("{\"flushed\":\"123\"}")).Return(nil)
	suite.binding.writeFeedback(flushed)
}

func (suite *ServerTest) TestServerFailuresResponse() {
	errorMessage := &e2SharedModels.ErrorMsg{
		ErrType: e2SharedModels.ServerErr,
	}
	suite.mockSessionClient.On("WriteBinaryAsText", []byte("{\"error\":{\"code\":\"\",\"message\":\"\"}}")).Return(nil)
	suite.mockProcessor.On("CleanData").Once()
	suite.mockProcessor.On("SetToPauseState").Once()

	suite.binding.writeFeedback(errorMessage)
}
