package server

import (
	"testing"

	rmocks "code.justin.tv/devhub/mdaas-ingest/ratelimiter/mocks"

	pmocks "code.justin.tv/devhub/mdaas-ingest/processor/mocks"
	smocks "code.justin.tv/devhub/twitch-e2-ingest/session/mocks"
	"github.com/stretchr/testify/suite"
)

type ServerTest struct {
	suite.Suite
	mockSessionClient *smocks.Client
	mockProcessor     *pmocks.Processor
	mockRateLimiter   *rmocks.RateLimiter
	binding           Binding
}

func (suite *ServerTest) SetupTest() {
	suite.mockSessionClient = &smocks.Client{}
	suite.mockProcessor = &pmocks.Processor{}
	suite.mockRateLimiter = &rmocks.RateLimiter{}
	suite.binding = Binding{suite.mockSessionClient, suite.mockProcessor, suite.mockRateLimiter, false, &Bindings{}}
}

func (suite *ServerTest) TearDownTest() {
	suite.mockSessionClient.AssertExpectations(suite.T())
	suite.mockProcessor.AssertExpectations(suite.T())
	suite.mockRateLimiter.AssertExpectations(suite.T())
}

func TestRunServerSuite(t *testing.T) {
	suite.Run(t, new(ServerTest))
}
