package server

import (
	"encoding/json"

	. "code.justin.tv/devhub/mdaas-ingest/models"
)

func (b Binding) validateMessage(msg string) *ErrorMsg {
	var messageTypes MessageTypes
	err := json.Unmarshal([]byte(msg), &messageTypes)
	// initial validation is only for delta pack
	// if data is coming in too fast or too large, it should not even enter our buffer to be processed
	if err != nil || (messageTypes.Delta == nil && messageTypes.Refresh == nil && messageTypes.Connect == nil && messageTypes.Flush == nil) {
		return &BadDataPack
	} else if messageTypes.Delta != nil {
		if b.rateLimiter.IfExceedLimit() {
			return &DeltaRateLimitExceeded
		}

		// check if delta pack size is larger than 20kb
		if len([]byte(msg)) > 20*1000 {
			return &DeltaMaxSizeExceeded
		}
	} else if messageTypes.Connect != nil || messageTypes.Refresh != nil {
		if len([]byte(msg)) > 100*1000 {
			if messageTypes.Connect != nil {
				return &ConnectMaxSizeExceeded
			} else {
				return &RefreshMaxSizeExceeded
			}
		}
	} else if messageTypes.Flush != nil {
		if *messageTypes.Flush == "" {
			return &BadDataPack
		}
	}
	return nil
}
