package server

import (
	"code.justin.tv/devhub/mdaas-ingest/models"
)

func (suite *ServerTest) TestValidateMessageWithValidMessage() {
	suite.mockRateLimiter.On("IfExceedLimit").Return(false)
	err := suite.binding.validateMessage(DeltaStrStandard)
	suite.Nil(err)
}

func (suite *ServerTest) TestValidateMessage() {
	suite.mockRateLimiter.On("IfExceedLimit").Return(true)
	err := suite.binding.validateMessage(DeltaStrStandard)
	suite.Equal(models.DeltaRateLimitExceeded, *err)
}
