package test_utils

import (
	"code.justin.tv/devhub/mdaas-ingest/models"
)

const TestClientID = "testClientID"
const TestToken = "testToken"
const TestGameID = "testGameID"
const TestBroadcasterID = "testBroadcasterID"
const TestFirstKeyFrame = "testFirstKeyFrame"
const TestLastFullState = "testLastFullState"
const TestFlushID = "flushID"
const TestTag1 = "oe2ifj2oifjo2ijfo2i3jfo23ijf"
const TestTag2 = "2oifj2oifj2ofij23oifj2o3ifjo2"
const TestTag3 = "325c99b2-ca6f-4708-9d1f-e1f8710af675"
const TestSessionID = "testSessionID"

var StandardConnectionData = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [
			"testBroadcasterID"
		],
		"game_id": "testGameID",
		"env": "dev",
		"session_id": "testSessionID",
		"data": {
			"_metadata": {
				"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var ConnectionBadMetadataMissingID = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [],
		"game_id": "testGameID",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var ConnectionBadTags = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [],
		"game_id": "testGameID",
		"session_id": "testSessionID",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": "bad",
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var ConnectionMissingMetadata = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [],
		"game_id": "testGameID",
		"env": "dev",
		"session_id": "testSessionID",
		"data": {
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardConnectionDataMultiBroadcaster = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [
			"testBroadcasterID1",
			"testBroadcasterID2"
		],
		"game_id": "testGameID",
		"session_id": "testSessionID",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardConnectionDataUserToken = `{
	"connect": {
		"token": "testToken",
		"broadcaster_ids": [],
		"game_id": "testGameID",
		"session_id": "testSessionID",
		"env": "dev",
		"data": {
			"_metadata": {
				"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardRefresh = `{
	"refresh": {
		"data": {
			"_metadata": {
				"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
				"active": true

			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardRefreshMissingActive = `{
	"refresh": {
		"data": {
			"_metadata": {},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardRefreshBadTags = `{
	"refresh": {
		"data": {
			"_metadata": {
				"tags": "bad",
				"active": true
			},
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardRefreshMissingMetadata = `{
	"refresh": {
		"data": {
			"damage_dealt": 12092,
			"position": [
				[1, 2],
				[3, 4]
			],
			"champion": {
				"name": "lulu",
				"resource": [1, 2, 3, 4],
				"skill": {
					"q": 1,
					"w": 3
				}
			}
		}
	}
}`

var StandardDeltaPackWithFullReplace = `{
	"delta": [{
		"_metadata": {
			"tags": ["` + TestTag1 + `","` + TestTag2 + `"],
			"active": true

		},
		"damage_dealt": 12092,
		"position": [
			[1, 2],
			[3, 4]
		],
		"champion": {
			"name": "lulu",
			"resource": [1, 2, 3, 4],
			"skill": {
				"q": 1,
				"w": 3
			}
		}
	}]
}`

var StandardDeltaPackWithDeltaOps = `{"delta":[["damage_dealt", 10000], ["champion.skill.e", 2]]}`
var StandardDeltaPackChangeMetadata = `{"delta":[["_metadata.tags",["` + TestTag3 + `"]]]}`

var DeltaPackMissingMetadata = `{"delta":[["_metadata"], ["champion.skill.e", 2]]}`
var DeltaPackBadTags = `{"delta":[["_metadata.tags", "test"], ["champion.skill.e", 2]]}`
var DeltaPackWithBadMetadataActive = `{"delta":[["_metadata.active", "test"], ["champion.skill.e", 2]]}`

var StandardFlushPack = `{"flush":"flushID"}`

// GenerateMessageInfoFromRawMessage is for quickly transforming string to MessageInfo
func GenerateMessageInfoFromRawMessage(message string, time int64) models.MessageInfo {
	return models.MessageInfo{Message: message, Time: time}
}
