package jdelta

import (
	"encoding/json"
)

func FullStateStringToMap(fullStateStr string) (map[string]interface{}, error) {
	var fullState map[string]interface{}
	if err := json.Unmarshal([]byte(fullStateStr), &fullState); err != nil {
		return nil, ErrParseInputFullState
	}
	return fullState, nil
}

func DeltaStateStringToOperationArray(deltaStateStr string) ([][]interface{}, error) {
	var deltaStates [][]interface{}
	if err := json.Unmarshal([]byte(deltaStateStr), &deltaStates); err != nil {
		return nil, ErrParseInputDeltaState
	}
	return deltaStates, nil
}

func DeltaStateStringTranslateHelper(deltaStateStr string) ([]interface{}, error) {
	var deltaStates []interface{}
	if err := json.Unmarshal([]byte(deltaStateStr), &deltaStates); err != nil {
		return nil, ErrParseInputDeltaState
	}
	return deltaStates, nil
}

func DeltaStateStringToInterface(deltaStateStr string) ([]interface{}, error) {
	var deltaStates []interface{}
	if err := json.Unmarshal([]byte(deltaStateStr), &deltaStates); err != nil {
		return nil, ErrParseInputDeltaState
	}
	return deltaStates, nil
}
