package jdelta

import (
	"encoding/json"
	"fmt"

	"errors"

	"github.com/go-test/deep"
)

var fullStateStr = `{
	"damage_dealt": 12092,
	"position": [
		[1, 2],
		[3, 4]
	],
	"champion": {
		"name": "lulu",
		"resource": [1, 2, 3, 4],
		"skill": {
			"q": 1,
			"w": 3
		}
	}
}`

var fullStateStr2 = `
{
  "foo": {
    "bar": [[
      {
        "one": [1, 2]
      },
      {
        "two": [3, 4]
      }
    ]]
  }
}`

var fullStateStr3 = `{"test": {"a": {"b": 2, "x":1}}}`
var fullStateStr4 = `{"test": {"a": 3}}`

func compareFullStateEqual(expectedStr string, actualFullState interface{}) (bool, error) {
	a, err := FullStateStringToMap(expectedStr)
	if err != nil {
		return false, err
	}

	actualFullStateStr, err := json.Marshal(actualFullState)
	if err != nil {
		return false, err
	}

	b, err := FullStateStringToMap(string(actualFullStateStr))
	if err != nil {
		return false, err
	}

	diff := deep.Equal(a, b)
	if len(diff) != 0 {
		fmt.Println(diff)
		return false, errors.New("not equal")
	}
	return true, nil
}
