package lifecycle

import (
	"fmt"
	"strings"
)

type ErrorList interface {
	error
	Append(error)
	IsEmpty() bool
	Expand() []error
}

type errorList struct {
	errors []error
}

func (e *errorList) Append(err error) {
	e.errors = append(e.errors, err)
}

func NewErrorList(errs ...error) ErrorList {
	return &errorList{errs}
}

func (e *errorList) Expand() []error {
	out := make([]error, len(e.errors))
	copy(out, e.errors)
	return out
}

func (e *errorList) IsEmpty() bool {
	return e.errors == nil
}

func (e *errorList) Error() string {
	length := len(e.errors)
	errStr := make([]string, length)
	for i, e := range e.errors {
		errStr[i] = e.Error()
	}
	suffix := ""
	if length > 0 {
		suffix = "\n"
	}
	return fmt.Sprintf("%d errors%s%s", length, suffix, strings.Join(errStr, "\n"))
}
