package dynamo

import (
	"context"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (a *allowlist) DeleteAllowlistEntry(ctx context.Context, gameID, clientID string) error {
	_, err := a.dynamo.DeleteItemWithContext(ctx, &dynamodb.DeleteItemInput{
		TableName: &a.tableName,
		Key: map[string]*dynamodb.AttributeValue{
			"GameID":   {S: &gameID},
			"ClientID": {S: &clientID},
		},
	})
	return err
}
