package dynamo

import (
	"context"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

type ListClientsRequest struct {
	GameID         string
	OrganizationID string
}

func (a *allowlist) ListClients(ctx context.Context, r *ListClientsRequest) ([]*Client, error) {
	const keyConditionExpression = "GameID = :gameID"
	input := &dynamodb.QueryInput{
		TableName:              aws.String(a.tableName),
		KeyConditionExpression: aws.String(keyConditionExpression),
		ExpressionAttributeValues: map[string]*dynamodb.AttributeValue{
			":gameID": {S: aws.String(r.GameID)},
		},
	}

	if r.OrganizationID != "" {
		input.FilterExpression = aws.String("OrganizationID = :organizationID")
		input.ExpressionAttributeValues[":organizationID"] = &dynamodb.AttributeValue{S: aws.String(r.OrganizationID)}
	}

	output, err := a.dynamo.QueryWithContext(ctx, input)
	if err != nil {
		return nil, err
	}

	var entries []*AllowlistEntry
	if err := dynamodbattribute.UnmarshalListOfMaps(output.Items, &entries); err != nil {
		return nil, err
	}

	clients := make([]*Client, len(entries))
	for i, entry := range entries {
		client := &Client{
			ID:        entry.ClientID,
			CreatedAt: entry.CreatedAt,
		}
		clients[i] = client
	}

	return clients, nil
}
