package iam

import (
	"encoding/json"
	"strconv"
)

type PolicyDocument struct {
	Statement []PolicyStatement `json:"Statement"`
	Version   string            `json:"Version"`
}

type PolicyStatement struct {
	Action    []string  `json:"Action"`
	Condition Condition `json:"Condition,omitempty"`
	Effect    Effect    `json:"Effect"`
	Principal Principal `json:"Principal"`
	Resource  string    `json:"Resource"`
	Sid       string    `json:"Sid"`
}

type Effect string

const (
	EffectAllow Effect = "Allow"
	EffectDeny  Effect = "Deny"
)

type Condition map[string]map[string]string

func StringEquals(key, value string) Condition {
	return Condition{"StringEquals": {key: value}}
}

type Principal map[string][]string

func AWSAccountIDs(accountIDs ...string) Principal {
	return Principal{"AWS": accountIDs}
}

func PolicyDocumentJSON(statements ...PolicyStatement) (string, error) {
	for i := range statements {
		statements[i].Sid = strconv.Itoa(i)
	}
	bytes, err := json.Marshal(PolicyDocument{
		Statement: statements,
		Version:   "2012-10-17",
	})
	if err != nil {
		return "", err
	}
	return string(bytes), err
}
