package models

type ClientType string

const (
	AppToken  = "app"
	UserToken = "user"
)

type GameData struct {
	BroadcasterIDs []string               `json:"broadcaster_ids"`
	Env            string                 `json:"env"`
	GameID         string                 `json:"game_id"`
	MetadataDelta  map[string]interface{} `json:"metadata_delta"`
}

type GameFullData struct {
	Active         bool        `json:"active"`
	ClientID       string      `json:"client_id"`
	Env            string      `json:"env"`
	BroadcasterIDs []string    `json:"broadcaster_ids"`
	GameID         string      `json:"game_id"`
	Time           int64       `json:"time"`
	SessionID      string      `json:"session_id"`
	ConnectionID   int64       `json:"connection_id"`
	MessageID      int64       `json:"message_id"`
	ClientType     ClientType  `json:"client_type"`
	Data           interface{} `json:"data"`
}
