package sns

import (
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

type Config struct {
	AWSRegion       string
	RetryDelay      time.Duration
	RetryCount      int
	SampleReporter  telemetry.SampleReporter
	RoleARN         string // The IAM role to assume for cross-account SNS access.
	DefaultTopicARN string // The default SNS topic ARN to publish to.
	AWSAccountIDs
}

// AWS account IDs that are permitted to publish to SNS topics.
type AWSAccountIDs struct {
	E2IngestHTTP string
	LeagueCME    []string
	AllAccess    []string
}

const (
	defaultAWSRegion  = "us-west-2"
	defaultRetryDelay = 100 * time.Millisecond
	defaultRetryCount = 10
)

func (c *Config) awsRegion() string {
	if c.AWSRegion == "" {
		return defaultAWSRegion
	}
	return c.AWSRegion
}

func (c *Config) retryDelay() time.Duration {
	if c.RetryDelay == 0 {
		return defaultRetryDelay
	}
	return c.RetryDelay
}

func (c *Config) retryCount() int {
	if c.RetryCount == 0 {
		return defaultRetryCount
	}
	return c.RetryCount
}
