package sns

import (
	"encoding/json"
	"errors"
	"fmt"
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/sns"
)

// publish attempts to publish the given event to specific SNS topic.
// Errors during publish will be reported to Rollbar.
func (p *publisherImpl) PublishByARN(data interface{}, arn string) error {

	dataBytes, err := json.Marshal(data)
	if err != nil {
		return errors.New("error marshalling SNS payload")
	}

	message := Message{
		Default: string(dataBytes),
	}

	messageBytes, err := json.Marshal(message)
	if err != nil {
		return errors.New("error marshalling SNS payload")
	}

	in := &sns.PublishInput{
		Message:          aws.String(string(messageBytes)),
		MessageStructure: aws.String("json"),
		MessageAttributes: map[string]*sns.MessageAttributeValue{
			"event": {
				StringValue: aws.String(eventName),
				DataType:    aws.String("String"),
			},
		},
		TopicArn: aws.String(arn),
	}

	for i := 0; i < p.config.retryCount(); i++ {
		_, err = p.snsClient.Publish(in)
		if err != nil {
			p.config.SampleReporter.Report(fmt.Sprintf("sns_error_%s", err.Error()), 1.0, telemetry.UnitCount)
		} else {
			return nil
		}
		time.Sleep(p.config.retryDelay())
	}

	return err
}
