package logging

// Function is the expected signature for a provided logging function.
// The level should be used to decide when to skip the log.
// The msg should be concatenated with spaces, similar to fmt.Println.
// Example: a simple log function that prints to stdout with Info level or greater:
//     loggerFn := logging.NewFilter(logging.Info, log.Println).Log
//     loggerFn(logging.Error, "code:", 400) //=> prints "code: 400\n"
//     loggerFn(logging.Debug, "foobar")     //=> does nothing
type Function func(level Level, msg ...interface{})

// Noop is a logging.Function that does nothing
func Noop(level Level, msg ...interface{}) {}
