package logging

type Level uint8

const (
	Trace   Level = 0
	Debug   Level = 1
	Info    Level = 2
	Warning Level = 3
	Error   Level = 4
)

func (l Level) String() string {
	switch l {
	case Trace:
		return "trace"
	case Debug:
		return "debug"
	case Info:
		return "info"
	case Warning:
		return "warning"
	case Error:
		return "error"
	default:
		return "?"
	}
}

func ParseLevel(value string) (Level, bool) {
	switch value {
	case "0", "trace":
		return Trace, true
	case "1", "debug":
		return Debug, true
	case "2", "info":
		return Info, true
	case "3", "warning":
		return Warning, true
	case "4", "error":
		return Error, true
	default:
		return Trace, false // invalid
	}
}

func ParseLevelOrDefault(value string, deflvl Level) Level {
	if level, ok := ParseLevel(value); ok {
		return level
	}
	return deflvl
}
