package timeout

import (
	"io"
	"net"
	"time"
)

type reader struct {
	conn    net.Conn
	sampler Sampler
}

func NewReader(sampler Sampler, conn net.Conn) io.Reader {
	return &reader{conn, sampler}
}

func (r *reader) Read(p []byte) (n int, err error) {
	r.conn.SetReadDeadline(time.Now().Add(r.sampler.Next()))
	n, err = r.conn.Read(p)
	return
}

func (r *reader) RemoveDeadline() {
	r.conn.SetReadDeadline(time.Time{})
}
