package websocket

import (
	"crypto/tls"
	"net"
	"time"

	"code.justin.tv/devhub/lib-lifecycle/src/lifecycle"
	"code.justin.tv/karlpatr/message-prototype/libs/logging"
	"code.justin.tv/karlpatr/message-prototype/libs/timeout"
)

const defaultDuration = 10 * time.Second

type TimeoutBehavior int32

const (
	Ping       TimeoutBehavior = 0
	Disconnect TimeoutBehavior = 1
)

type Settings struct {
	Certs       *tls.Config
	Logger      logging.Function
	Lifecycle   lifecycle.Manager
	Timeout     timeout.Sampler
	OnTimeout   TimeoutBehavior
	HealthCheck *string
}

func fixup(settings *Settings) *Settings {
	out := &Settings{settings.Certs, settings.Logger, settings.Lifecycle, settings.Timeout, settings.OnTimeout, settings.HealthCheck}
	if out.Timeout == nil {
		out.Timeout = timeout.NewConstantSampler(defaultDuration)
	}
	if out.Logger == nil {
		out.Logger = logging.Noop
	}
	return out
}

func (s *Settings) gracefulClose(c net.Conn) error {
	err := filterClosed(c.Close())
	if err != nil {
		s.Logger(logging.Debug, "Closed:", c.RemoteAddr(), err)
	} else {
		s.Logger(logging.Trace, "Closed:", c.RemoteAddr())
	}
	return err
}
