import { AbilityHistory } from '../../models/ability-history';
import { Abilities, Ability } from '../../models/league-api/all-game-data';

export function createAbilityHistory(
  newAbilities: Abilities,
  oldAbilities: Abilities,
  history: AbilityHistory[],
  timestamp: number
) {
  const abilities = Object.entries(newAbilities) as [keyof Abilities, Ability][];

  const newHistory = [...history];
  for (const [key, newAbility] of abilities) {
    const oldAbility = oldAbilities[key];
    if (newAbility && oldAbility && newAbility.abilityLevel !== undefined && oldAbility.abilityLevel !== undefined) {
      if (newAbility.abilityLevel !== oldAbility.abilityLevel) {
        newHistory.push({
          name: newAbility.displayName,
          level: newAbility.abilityLevel,
          id: newAbility.id,
          key,
          timestamp
        });
      }
    }
  }

  return newHistory;
}
