import { ItemAction, ItemInteraction } from '../../models/item-history';
import { Item } from '../../models/league-api/all-game-data';

export function createItemHistory(
  newItems: Item[],
  oldItems: Item[],
  history: ItemInteraction[],
  timestamp: number
): ItemInteraction[] {
  const newHistory = [...history];

  // TODO: this is WIP and will need to make this more robust.
  // It passes tests but needs to handle duplicate items and items that are same value but not same reference
  const newItemsComparable: Item[] = createComparableItemList(newItems);
  const oldItemsComparable: Item[] = createComparableItemList(oldItems);

  // check all new items
  newItemsComparable.forEach(itemComparable => {
    if (itemComparable !== undefined && itemComparable.count !== undefined && itemComparable.itemID !== undefined) {
      if (!oldItemsComparable.some(x => isItemSame(x, itemComparable))) {
        // if the new item doesn't exist in our old item set, add item interaction to history
        newHistory.push(new ItemInteraction(timestamp, itemComparable, ItemAction.Added));
      } else if (
        oldItemsComparable.some(
          x => isItemSame(x, itemComparable) && x.count !== undefined && x.count < itemComparable!.count!
        )
      ) {
        // if the new item exists in our old item set but has increased count, add item interaction to history
        newHistory.push(new ItemInteraction(timestamp, itemComparable, ItemAction.Added));
      }
    }
  });

  oldItemsComparable.forEach(itemComparable => {
    if (itemComparable !== undefined && itemComparable.count !== undefined && itemComparable.itemID !== undefined) {
      if (!newItemsComparable.some(x => isItemSame(x, itemComparable))) {
        // if the old item doesn't exist in our new item set, add item interaction to history (a removal)
        newHistory.push(new ItemInteraction(timestamp, itemComparable, ItemAction.Removed));
      } else if (
        newItemsComparable.some(
          x => isItemSame(x, itemComparable) && x.count !== undefined && x.count < itemComparable!.count!
        )
      ) {
        // if the old item exists in our new item set but has decreased count, add item interaction to history (removal)
        newHistory.push(new ItemInteraction(timestamp, itemComparable, ItemAction.Removed));
      }
    }
  });
  return newHistory;
}

function createComparableItemList(items: Item[]): Item[] {
  const itemComparableList: Item[] = new Array();
  items.forEach(item => {
    if (item.itemID !== undefined && !itemComparableList.some(x => isItemSame(x, item))) {
      itemComparableList.push({ ...item });
    } else {
      incrementItemCount(itemComparableList, item);
    }
  });

  return itemComparableList;
}

function isItemSame(a: Item, b: Item): boolean {
  return a.itemID === b.itemID;
}

function incrementItemCount(itemComparableList: Item[], item: Item) {
  const foundItem = itemComparableList.find(x => isItemSame(x, item));
  if (foundItem !== undefined && foundItem.count !== undefined && item !== undefined && item.count !== undefined) {
    foundItem.count += item.count;
  } else {
    console.log('Error occured when trying to increment comparable items.');
  }
}
