import { MDaaSPayload } from '../../models/mdaas-payload';
import { LeagueOfLegendsDataCache } from './../../models/league-data-cache';

export function createMDaaSPayload(dataCache: LeagueOfLegendsDataCache): MDaaSPayload {
  return {
    ...dataCache.gameData,
    abilityHistory: dataCache.abilityHistory,
    itemHistory: dataCache.itemHistory,
    region: dataCache.region || 'N/A',
    allPlayers: dataCache.allPlayers
  };
}
