import { AllPlayer, Team } from '../../models/league-api/all-game-data';
import { OrderedAllPlayer } from '../../models/ordered-player';

export function createPlayerMap(players: AllPlayer[], currentMap: { [key: string]: OrderedAllPlayer }) {
  const newMap = Object.assign({}, currentMap);
  let chaosIndex = 0;
  let orderIndex = 0;

  for (const player of players) {
    if (!player.summonerName) {
      continue;
    }

    if (player.team === Team.Chaos) {
      const orderedAllPlayer = {
        ...player,
        order: chaosIndex
      };

      newMap[player.summonerName] = orderedAllPlayer;

      chaosIndex++;
    } else if (player.team === Team.Order) {
      const orderedAllPlayer = {
        ...player,
        order: orderIndex
      };

      newMap[player.summonerName] = orderedAllPlayer;
      orderIndex++;
    }
  }
  return newMap;
}
