import { Item } from './league-api/all-game-data';

export class ItemInteraction {
  public timestamp: number;
  public consumable: boolean;
  public name: string;
  public itemID: number;
  public action: ItemAction;

  constructor(timestamp: number, item: Item, action: ItemAction) {
    this.timestamp = timestamp;
    this.consumable = item.consumable || false;
    this.itemID = item.itemID || -1;
    this.name = item.displayName || '';
    this.action = action;
  }
}

export enum ItemAction {
  Removed = 'removed',
  Added = 'added'
}
