import { AbilityHistory } from '../ability-history';
import { ItemInteraction } from '../item-history';

export interface AllGameData {
  activePlayer?: ActivePlayer;
  allPlayers?: AllPlayer[];
  events?: Events;
  gameData?: GameData;
}

export interface ActivePlayer {
  abilities?: Abilities;
  championStats?: ChampionStats;
  currentGold?: number;
  fullRunes?: FullRunes;
  level?: number;
  summonerName?: string;
}

export interface Abilities {
  E?: Ability;
  Passive?: Ability;
  Q?: Ability;
  R?: Ability;
  W?: Ability;
}

export interface Ability {
  abilityLevel?: number;
  displayName: string;
  id?: string;
  rawDescription: string;
  rawDisplayName: string;
}

export interface ChampionStats {
  abilityPower?: number;
  armor?: number;
  armorPenetrationFlat?: number;
  armorPenetrationPercent?: number;
  attackDamage?: number;
  attackRange?: number;
  attackSpeed?: number;
  bonusArmorPenetrationPercent?: number;
  bonusMagicPenetrationPercent?: number;
  cooldownReduction?: number;
  critChance?: number;
  critDamage?: number;
  currentHealth?: number;
  healthRegenRate?: number;
  lifeSteal?: number;
  magicLethality?: number;
  magicPenetrationFlat?: number;
  magicPenetrationPercent?: number;
  magicResist?: number;
  maxHealth?: number;
  moveSpeed?: number;
  physicalLethality?: number;
  resourceMax?: number;
  resourceRegenRate?: number;
  resourceType?: string;
  resourceValue?: number;
  spellVamp?: number;
  tenacity?: number;
}

export interface FullRunes {
  generalRunes?: Ability[];
  keystone?: Ability;
  primaryRuneTree?: Ability;
  secondaryRuneTree?: Ability;
  statRunes?: StatRune[];
}

export interface StatRune {
  id?: number;
  rawDescription?: string;
}

export interface AllPlayer {
  championName?: string;
  isBot?: boolean;
  isDead?: boolean;
  items?: Item[];
  level?: number;
  position?: string;
  rawChampionName?: string;
  respawnTimer?: number;
  runes?: Runes;
  scores?: Scores;
  skinID?: number;
  summonerName?: string;
  summonerSpells?: SummonerSpells;
  team?: Team;
  rawSkinName?: string;
  skinName?: string;
}

export interface Item {
  canUse?: boolean;
  consumable?: boolean;
  count?: number;
  displayName?: string;
  itemID?: number;
  price?: number;
  rawDescription?: string;
  rawDisplayName?: string;
  slot?: number;
}

export interface Runes {
  keystone?: Ability;
  primaryRuneTree?: Ability;
  secondaryRuneTree?: Ability;
}

export interface Scores {
  assists?: number;
  creepScore?: number;
  deaths?: number;
  kills?: number;
  wardScore?: number;
}

export interface SummonerSpells {
  summonerSpellOne?: Ability;
  summonerSpellTwo?: Ability;
}

export enum Team {
  Chaos = 'CHAOS',
  Order = 'ORDER'
}

export interface Events {
  Events?: Event[];
}

export interface Event {
  EventID?: number;
  EventName?: string;
  EventTime?: number;
  Assisters?: string[];
  KillerName?: string;
  VictimName?: string;
  Recipient?: string;
  KillStreak?: number;
  TurretKilled?: string;
  DragonType?: string;
  Stolen?: string;
}

export interface GameData {
  gameMode?: string;
  gameTime?: number;
  mapName?: string;
  mapNumber?: number;
}
