import fetchMock from 'fetch-mock';
const fetchSandbox = fetchMock.sandbox();
jest.setMock('node-fetch', fetchSandbox);

import { LeagueOfLegendsSidecarClient } from '../../src/league-of-legends';
import { ACTIVEPLAYERNAME_URL } from '../../src/league-of-legends/constants';
import { ACTIVEPLAYERNAME } from './mockData/ActivePlayerName';

describe('League Local API Client', () => {
  beforeEach(() => {
    fetchSandbox.reset();
  });
  it('should have port 2999', () => {
    const sidecar = new LeagueOfLegendsSidecarClient();
    expect(sidecar.port).toBe(2999);
  });
  it('should return API responsive', async () => {
    const sidecar = new LeagueOfLegendsSidecarClient();
    fetchSandbox.get(ACTIVEPLAYERNAME_URL, 200);
    const responsive = await sidecar.isResponsive();
    expect(responsive).toBe(true);
  });
  it('should return Coach Tallanasty', async () => {
    fetchSandbox.get(ACTIVEPLAYERNAME_URL, JSON.stringify(ACTIVEPLAYERNAME));
    const sidecar = new LeagueOfLegendsSidecarClient();
    expect(await sidecar.getActivePlayerName()).toBe(ACTIVEPLAYERNAME);
  });
  it('should pass data to mdaas', async () => {
    fetchSandbox.get(ACTIVEPLAYERNAME_URL, JSON.stringify(ACTIVEPLAYERNAME));
    const sidecar = new LeagueOfLegendsSidecarClient();
    sidecar.setupMDaaSConnection();
    expect(await sidecar.getActivePlayerName()).toBe(ACTIVEPLAYERNAME);
  });
  // it('should return running', async () => {
  //   const sidecar = new LeagueOfLegendsSidecarClient();
  //   expect(await sidecar.isLeagueRunning()).toBe(true);
  // });
});
