import { createItemHistory } from '../../../src/league-of-legends/transforms/item-history';
import { ItemAction, ItemInteraction } from '../../../src/models/item-history';
import { Item } from '../../../src/models/league-api/all-game-data';
import * as shop from '../mockData/items';

const InitialBuyTime = 15;
const FirstBackBuyTime = 600;
const MidgameBuyTime = 1200;
const EndGameBuyTime = 9999;
const itemSet0: Item[] = [];
const itemSet1 = [{ ...shop.DoranBlade }, { ...shop.WardingTotem }];
const itemSet2 = [{ ...shop.DoranBlade }, { ...shop.BeserkersGreaves }, { ...shop.WardingTotem }];
const itemSet3 = [
  { ...shop.DoranBlade },
  { ...shop.BeserkersGreaves },
  { ...shop.WardingTotem },
  { ...shop.InfinityEdge }
];
const itemSet4 = [shop.InfinityEdge2, shop.BeserkersGreaves, shop.WardingTotem, shop.InfinityEdge];

const initialHistory: ItemInteraction[] = [];
const firstBuyHistory = createItemHistory(itemSet1, itemSet0, initialHistory, InitialBuyTime);
const firstBackHistory = createItemHistory(itemSet2, itemSet1, firstBuyHistory, FirstBackBuyTime);
const midGameBackHistory = createItemHistory(itemSet3, itemSet2, firstBackHistory, MidgameBuyTime);
const endBackHistory = createItemHistory(itemSet4, itemSet3, midGameBackHistory, EndGameBuyTime);

describe('Transformer - Item History', () => {
  it('Adds a new item entry', () => {
    expect(firstBuyHistory.length).toBe(2);
    expect(firstBuyHistory[0]!.itemID).toBe(shop.DoranBlade.itemID);
    expect(firstBuyHistory[0]!.timestamp).toBe(InitialBuyTime);
    expect(firstBuyHistory[0]!.action).toBe(ItemAction.Added);
  });

  it('Adds additional items', () => {
    expect(firstBackHistory.length).toBe(3);
    expect(firstBackHistory[2]!.itemID).toBe(shop.BeserkersGreaves.itemID);
    expect(firstBackHistory[2]!.timestamp).toBe(FirstBackBuyTime);
    expect(firstBackHistory[2]!.action).toBe(ItemAction.Added);
  });

  it('Adds Legendary item', () => {
    expect(midGameBackHistory.length).toBe(4);
    expect(midGameBackHistory[3]!.itemID).toBe(shop.InfinityEdge.itemID);
    expect(midGameBackHistory[3]!.timestamp).toBe(MidgameBuyTime);
    expect(midGameBackHistory[3]!.action).toBe(ItemAction.Added);
  });

  it('Adds Repeated Item', () => {
    expect(endBackHistory.length).toBe(6);
    expect(endBackHistory[4]!.itemID).toBe(shop.InfinityEdge.itemID);
    expect(endBackHistory[4]!.timestamp).toBe(EndGameBuyTime);
    expect(endBackHistory[4]!.action).toBe(ItemAction.Added);
  });

  it('Removed "Sold" Item and is marked as removed', () => {
    expect(endBackHistory.length).toBe(6);
    expect(endBackHistory[5]!.itemID).toBe(shop.DoranBlade.itemID);
    expect(endBackHistory[5]!.timestamp).toBe(EndGameBuyTime);
    expect(endBackHistory[5]!.action).toBe(ItemAction.Removed);
  });
});
