package main

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"log"
	"os/exec"
	"strings"
	"testing"

	"code.justin.tv/devhub/mdaas-tags-translator/internal/clients/redis"
	"code.justin.tv/devhub/mdaas-tags-translator/models"
	"github.com/aws/aws-lambda-go/events"
	"github.com/stretchr/testify/assert"
)

const (
	missingValuesJSON = `{
		"activePlayer": {
			"summonerName": "randomCharacter"
		}
	}`
	validJSON = `{
		"activePlayer": {
			"summonerName": "randomCharacter"
		},
		"allPlayers": {
			"randomCharacter": {
				"rawChampionName": "game_character_displayname_Classic"
			}
		},
		"gameData": {
			"gameMode": "PRACTICETOOL"
		}
	}`
	TestBroadcaster1 = "TestBroadcaster1"
)

func TestRedis(t *testing.T) {
	r, err := redis.NewRedisClient(&redis.Config{})
	if err != nil {
		assert.Fail(t, fmt.Sprintf("Couldn't connect to redis: %v", err))
	}

	t.Run("Successfully stores in redis", func(t *testing.T) {
		expected := `["c122215b-a029-4a32-b812-c263c0268310","c6045372-7714-442d-9a53-0c03bf73d581"]`

		InvokeLambda(events.SNSEvent{
			Records: []events.SNSEventRecord{
				{
					SNS: getMessage(models.GameData{
						BroacastersID: []string{TestBroadcaster1},
						Data:          validJSON,
					}),
				},
			},
		})

		value, _ := r.Get(context.Background(), TestBroadcaster1)
		assert.Equal(t, expected, value)

		expected = "null"

		InvokeLambda(events.SNSEvent{
			Records: []events.SNSEventRecord{
				{
					SNS: getMessage(models.GameData{
						BroacastersID: []string{TestBroadcaster1},
						Data:          missingValuesJSON,
					}),
				},
			},
		})

		value, _ = r.Get(context.Background(), TestBroadcaster1)
		assert.Equal(t, expected, value)
	})
}

func InvokeLambda(snsEvent events.SNSEvent) {
	event, _ := json.Marshal(snsEvent)
	cmd := exec.Command("go", "run", "main.go", string(event))
	cmd.Stdin = strings.NewReader("some input")
	var out bytes.Buffer
	cmd.Stdout = &out
	err := cmd.Run()
	if err != nil {
		log.Fatal(err)
	}
	fmt.Printf("in all caps: %q\n", out.String())
}
