package main

import (
	"context"
	"encoding/json"
	"fmt"
	"os"

	"code.justin.tv/devhub/mdaas-tags-translator/internal/clients/redis"
	"code.justin.tv/devhub/mdaas-tags-translator/models"
	"code.justin.tv/devhub/mdaas-tags-translator/processor"
	"github.com/aws/aws-lambda-go/events"
	"github.com/aws/aws-lambda-go/lambda"
	"github.com/sirupsen/logrus"
)

func handleRequest(ctx context.Context, log *logrus.Logger, p processor.Processor, snsEvent events.SNSEvent) {
	for _, record := range snsEvent.Records {

		gameData := models.GameData{}

		if err := json.Unmarshal([]byte(record.SNS.Message), &gameData); err != nil {
			log.Error(err)
		}

		if err := p.Process(gameData); err != nil {
			log.Error(err)
		}
	}
}

func main() {
	log := logrus.New()
	log.SetFormatter(&logrus.JSONFormatter{})

	c := redis.Config{}
	r, err := redis.NewRedisClient(&c)
	if err != nil {
		log.Error(err)
	}

	p := processor.NewProcessor(r, log)

	if os.Getenv("ENVIRONMENT") == "local" {
		eventString := &events.SNSEvent{}

		err := json.Unmarshal([]byte(os.Args[1]), eventString)
		if err != nil {
			panic(fmt.Sprintf("Error Invoking Locally: %s", err))
		}

		handleRequest(context.Background(), log, p, *eventString)
		return
	}

	lambda.Start(handleRequest)
}
