package internal

import (
	"bytes"
	"fmt"
	"os"
	"os/exec"
)

func Must(err error, reason string) {
	if err != nil {
		switch err := err.(type) {
		case *exec.ExitError:
			Fatal("%s: %s\n%s", reason, err, bytes.TrimSpace(err.Stderr))
		default:
			Fatal("%s: %s", reason, err)
		}
	}
}

func Info(msg string, args ...interface{}) {
	fmt.Printf("\x1b[34m[INFO] "+msg+"\x1b[0m\n", args...)
}

func Warn(msg string, args ...interface{}) {
	fmt.Printf("\x1b[31m[WARN] "+msg+"\x1b[0m\n", args...)
}

func Error(msg string, args ...interface{}) {
	fmt.Printf("\x1b[1m[ERROR] "+msg+"\x1b[0m\n", args...)
}

func Fatal(msg string, args ...interface{}) {
	Error(msg, args...)
	os.Exit(1)
}
